<?php
    use App\Models\User;
    use Illuminate\Support\Facades\Auth;
    
?>
<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', app()->getLocale())); ?>"
    <?php echo e(str_replace('_', '-', app()->getLocale()) == 'ar' ? '' : ''); ?>>

<head>
    <meta charset="UTF-8" />
    <meta http-equiv="X-UA-Compatible" content="IE=edge" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <meta name="description"
        content="In today's digital realm, a compelling website is the key to connecting with a vast online audience, expanding your reach, and propelling your brand to new heights. Showcase your unique offerings, generate leads, and drive sales with a visually stunning and user-friendly website. Unleash your business potential and embrace the digital revolution with a cutting-edge website that fuels your success.">
    <title><?php echo e(__('messages.title')); ?></title>

    <link rel="icon" href="<?php echo e(asset('assets/images/favicon.svg')); ?>" type="image/png">
    <link rel="stylesheet" href=" <?php echo e(asset('assets/css/bootstrap-select.css ')); ?>">
    <link rel="stylesheet" href=" <?php echo e(asset('assets/css/flag-icon.min.css ')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('assets/css/bootstrap.css')); ?> " />
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/niceCountryInput.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/slick.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/slick-theme.css')); ?>">
    <link rel="stylesheet" href=" <?php echo e(asset('assets/css/style.css')); ?>" />
    <link rel="stylesheet" href=" <?php echo e(asset('assets/css/responsive.css')); ?>" />
    <!-- Google tag (gtag.js) -->
    <script async src="https://www.googletagmanager.com/gtag/js?id=G-8Q7DF13MYB"></script>
    <script>
        window.dataLayer = window.dataLayer || [];

        function gtag() {
            dataLayer.push(arguments);
        }
        gtag('js', new Date());
        gtag('config', 'G-8Q7DF13MYB');
    </script>
    <!-- Hotjar Tracking Code for https://websites.fowl.sa -->
    <script>
        (function(h, o, t, j, a, r) {
            h.hj = h.hj || function() {
                (h.hj.q = h.hj.q || []).push(arguments)
            };
            h._hjSettings = {
                hjid: 3543486,
                hjsv: 6
            };
            a = o.getElementsByTagName('head')[0];
            r = o.createElement('script');
            r.async = 1;
            r.src = t + h._hjSettings.hjid + j + h._hjSettings.hjsv;
            a.appendChild(r);
        })(window, document, 'https://static.hotjar.com/c/hotjar-', '.js?sv=');
    </script>

    <!-- Event snippet for Phone call lead conversion page -->
    <script>
        gtag('event', 'conversion', {
            'send_to': 'AW-11246388098/61B4CPajnLcYEIKH2fIp'
        });
    </script>
</head>

<?php if(str_replace('_', '-', app()->getLocale()) === 'en'): ?>

    <body class="direction-ltr">
<?php endif; ?>

<body class="direction-rtl">
    <header class="container-fluid container-fluid-header">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="header-content">
                        <div class="header-logo">
                            <a href="#">
                                <img src="<?php echo e(asset('assets/images/logo.svg')); ?>" alt="Logo" />
                            </a>
                        </div>
                        <nav class="navbar navbar-expand-lg">
                            <div class="collapse navbar-collapse menu_links" id="navbarSupportedContent">
                                <ul class="navbar-nav nav me-auto mb-lg-0">
                                    <li class="nav-item active">
                                        <a class="nav-link" href="#home"><?php echo e(__('messages.home')); ?></a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" href="#WhyChoose"><?php echo e(__('messages.WhyChooseUs')); ?></a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" href="#testimonial"><?php echo e(__('messages.testimonial')); ?></a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" href="#Portfolio"><?php echo e(__('messages.Portfolio')); ?></a>
                                    </li>
                                    <li class="nav-item">
                                        <a class="nav-link" href="#Contact"><?php echo e(__('messages.contact')); ?></a>
                                    </li>
                                </ul>
                                <div class="work-lang-btns work-lang-btns-res">
                                    <a href="https://wa.me/+966581506065" target="_blank"
                                        class="btn btn-header text-regular whatsapp-us __semiBold">
                                        <div class="call-box"><img src="<?php echo e(asset('assets/images/whatsapp.svg')); ?>"
                                                alt="whatsapp"></div> <?php echo e(__('messages.Whatsapp')); ?>

                                    </a>
                                    
                                    <a href="https://wa.me/+966581506065?text=مرحبا فاول أريد الحصول على إستشارة تساعدني على إنشاء موقع إلكتروني لمشروعي" target="_blank"
                                        class="btn btn-header text-regular free-consultation __semiBold"
                                        >
                                        <?php echo e(__('messages.FreeConsultation')); ?>

                                    </a>

                                </div>
                            </div>
                        </nav>
                        <div class="rightNavBtn">
                            <div class="work-lang-btns">
                                <a href="https://wa.me/+966581506065" target="_blank"
                                    class="btn btn-header text-regular whatsapp-us __semiBold">
                                    <div class="call-box"><img src="<?php echo e(asset('assets/images/whatsapp.svg')); ?>"
                                            alt="whatsapp"></div> <?php echo e(__('messages.Whatsapp')); ?>

                                </a>
                                <a href="https://wa.me/+966581506065?text=مرحبا فاول أريد الحصول على إستشارة تساعدني على إنشاء موقع إلكتروني لمشروعي" 
                                    target="_blank" class="btn btn-header text-regular free-consultation __semiBold">
                                    <?php echo e(__('messages.FreeConsultation')); ?>

                                </a>
                                
                            </div>
                        </div>
                        <button class="navbar-toggler" type="button" data-bs-toggle="collapse"
                            data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                            aria-expanded="false" aria-label="Toggle navigation">
                            <span class="navbar-toggler-icon"></span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <section class="container-fluid banner-area bg-darkGrey" id="home">

        <div class="container position-relative header-container">
            <div class="row m-0">
                <div class="col-12 header-section-content-wrapper __bold">
                    <?php echo e(__('messages.Elevate')); ?>

                </div>
                <div class="col-12 header-desc-text __regular">
                    <?php echo e(__('messages.CuttingEdge')); ?>

                </div>
                <div class="col-12 header-sol-text __semiBold">
                    <span><?php echo e(__('messages.WebsiteSolutions')); ?></span>
                </div>

                <div class="col-12 header-btn-primary">
                    <a href="https://wa.me/+966581506065" target="_blank" class="btn btn-yellow contact-btn-header">
                        <?php echo e(__('messages.OrderNow')); ?> <img class="btn-arrow"
                            src="<?php echo e(asset('assets/images/btn-arrow-blue.svg')); ?>" alt="arrow" />
                    </a>
                </div>
            </div>
        </div>
        <div class="waves"><img src="<?php echo e(asset('assets/images/waves.svg')); ?>" alt="circles" /></div>
        <a class="nav-link down-header-arrow" href="#WhyChoose">
            <img class="" src="<?php echo e(asset('assets/images/down-arrow.svg')); ?>" alt="downArrow">
        </a>
    </section>

    <section class="container-fluid common-section services-wrapper" id="WhyChoose">

        <div class="container">
            <div class="row">
                <div class="col-12 col-lg-8 why-choose-col-detail">
                    <div class="primaryHeading">
                        <?php echo e(__('messages.WhyNeeds')); ?>

                    </div>
                    <div class="primaryText mb-3">
                        <?php echo e(__('messages.aboutUs')); ?>

                    </div>
                    <div class="secondaryHeading secondaryHeadingWhyCoose">
                        <?php echo e(__('messages.BusinessGrowth')); ?>

                    </div>
                    <a href="https://wa.me/+966581506065" target="_blank" class="btn btn-primary">
                        <?php echo e(__('messages.OrderNow2')); ?> <img class="btn-arrow"
                            src="<?php echo e(asset('assets/images/btn-arrow-white.svg')); ?>" alt="arrow" />
                    </a>
                </div>
                <div class="col-sm-4">
                    <img class="why-choose-img" src="<?php echo e(asset('assets/images/why-choose.png')); ?>" alt="whyChoose">
                </div>
            </div>
            
            <div class="row row-slider" id="testimonial">
                
                <div class="col-12">
                    <div class="row">
                        <div class="col-12">
                            <div class="primaryHeading">
                                <?php echo e(__('messages.clientsHeading')); ?>

                            </div>
                            <div class="primaryText mb-3">
                                <?php echo e(__('messages.clientsText')); ?>

                            </div>
                        </div>
                    </div>
                    <div class='testimonials-container'>
                        <div class="slider-for">

                            <div class="tesSlideContent">
                                <div class="tesSlideDetail">
                                    <div class="tesSlideContentCol">
                                        <div class="testimonialQuote">
                                            <img class="quoteImg"
                                                src="<?php echo e(asset('assets/images/quote.svg')); ?>" alt="quote" />
                                        </div>
                                        <div class="testimonialHeading">
                                            <?php echo e(__('messages.Website_Design_Development')); ?>

                                        </div>
                                        <div class="testimonialText">
                                        <?php echo e(__('messages.Website_content')); ?>

                                        </div>
                                        <a href="https://topmodern.sa/" target="_blank" class="btn btn-primary">
                                            <?php echo e(__('messages.View_Project')); ?>

                                            <img class="btn-arrow"
                                                src="<?php echo e(asset('assets/images/btn-arrow-white.svg')); ?>" alt="arrow" />
                                        </a>
                                    </div>
                                    <div class="tesSlideDesigCol">
                                        <div class="tesDesigCard">
                                            <div class="client-logo"><img src="<?php echo e(asset('assets/images/aab-logo.png')); ?>" alt="client" /></div>
                                            <div class="clientDetail">
                                                <div class="clientName">
                                                <?php echo e(__('messages.Client_name')); ?>

                                                    
                                                </div>
                                                <div class="clientDesig">
                                                <?php echo e(__('messages.Project')); ?>, <?php echo e(__('messages.Top_Modern')); ?>

                                                </div>
                                            </div>
                                        </div>
                                        <div class="tesRatingCard">
                                            <div class="ratingStar">
                                                <img src="<?php echo e(asset('assets/images/star-white.svg')); ?>" alt="rating" />
                                            </div>
                                            <div class="ratingDetail">
                                                <div class="ratingDesig">
                                                <?php echo e(__('messages.Rating')); ?>

                                                </div>
                                                <div class="ratingName">
                                                <?php echo e(__('messages.Best')); ?>

                                                    
                                                </div>
                                            </div>
                                            <div class="ratingStar ratingStarRes">
                                                <img src="<?php echo e(asset('assets/images/star-white.svg')); ?>" alt="rating" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tesSlideContent">
                                <div class="tesSlideDetail">
                                    <div class="tesSlideContentCol">
                                        <div class="testimonialQuote">
                                            <img class="quoteImg"
                                                src="<?php echo e(asset('assets/images/quote.svg')); ?>" alt="quote" />
                                        </div>
                                        <div class="testimonialHeading">
                                            <?php echo e(__('messages.Website_Design_Development')); ?>

                                        </div>
                                        <div class="testimonialText">
                                        <?php echo e(__('messages.Website_Content_2')); ?>

                                            
                                        </div>
                                        <a href="https://numu.sa" target="_blank" class="btn btn-primary">
                                            <?php echo e(__('messages.View_Project')); ?>

                                            <img class="btn-arrow"
                                                src="<?php echo e(asset('assets/images/btn-arrow-white.svg')); ?>" alt="arrow" />
                                        </a>
                                    </div>
                                    <div class="tesSlideDesigCol">
                                        <div class="tesDesigCard">
                                            <div class="client-logo"><img src="<?php echo e(asset('assets/images/numu-logo.png')); ?>" alt="client" /></div>
                                            <div class="clientDetail">
                                                <div class="clientName">
                                                    <?php echo e(__('messages.client_name_2')); ?>

                                                </div>
                                                <div class="clientDesig">
                                                <?php echo e(__('messages.Project')); ?>, <?php echo e(__('messages.Numu_Garden')); ?> 
                                                </div>
                                            </div>
                                        </div>
                                        <div class="tesRatingCard">
                                            <div class="ratingStar">
                                                <img src="<?php echo e(asset('assets/images/star-white.svg')); ?>" alt="rating" />
                                            </div>
                                            <div class="ratingDetail">
                                                <div class="ratingDesig">
                                                <?php echo e(__('messages.Rating')); ?>

                                                </div>
                                                <div class="ratingName">
                                                <?php echo e(__('messages.Best')); ?>   
                                                </div>
                                            </div>
                                            <div class="ratingStar ratingStarRes">
                                                <img src="<?php echo e(asset('assets/images/star-white.svg')); ?>" alt="rating" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="tesSlideContent">
                                <div class="tesSlideDetail">
                                    <div class="tesSlideContentCol">
                                        <div class="testimonialQuote">
                                            <img class="quoteImg"
                                                src="<?php echo e(asset('assets/images/quote.svg')); ?>" alt="quote" />
                                        </div>
                                        <div class="testimonialHeading">
                                            <?php echo e(__('messages.Website_Design_Development')); ?>

                                        </div>
                                        <div class="testimonialText">
                                        <?php echo e(__('messages.Website_content')); ?>

                                        </div>
                                        <a href="https://topmodern.sa/" target="_blank" class="btn btn-primary">
                                            <?php echo e(__('messages.View_Project')); ?>

                                            <img class="btn-arrow"
                                                src="<?php echo e(asset('assets/images/btn-arrow-white.svg')); ?>" alt="arrow" />
                                        </a>
                                    </div>
                                    <div class="tesSlideDesigCol">
                                        <div class="tesDesigCard">
                                            <div class="client-logo"><img src="<?php echo e(asset('assets/images/aab-logo.png')); ?>" alt="client" /></div>
                                            <div class="clientDetail">
                                                <div class="clientName">
                                                <?php echo e(__('messages.Client_name')); ?>

                                                    
                                                </div>
                                                <div class="clientDesig">
                                                <?php echo e(__('messages.Project')); ?>, <?php echo e(__('messages.Top_Modern')); ?>

                                                </div>
                                            </div>
                                        </div>
                                        <div class="tesRatingCard">
                                            <div class="ratingStar">
                                                <img src="<?php echo e(asset('assets/images/star-white.svg')); ?>" alt="rating" />
                                            </div>
                                            <div class="ratingDetail">
                                                <div class="ratingDesig">
                                                <?php echo e(__('messages.Rating')); ?>

                                                </div>
                                                <div class="ratingName">
                                                <?php echo e(__('messages.Best')); ?>

                                                    
                                                </div>
                                            </div>
                                            <div class="ratingStar ratingStarRes">
                                                <img src="<?php echo e(asset('assets/images/star-white.svg')); ?>" alt="rating" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="tesSlideContent">
                                <div class="tesSlideDetail">
                                    <div class="tesSlideContentCol">
                                        <div class="testimonialQuote">
                                            <img class="quoteImg"
                                                src="<?php echo e(asset('assets/images/quote.svg')); ?>" alt="quote" />
                                        </div>
                                        <div class="testimonialHeading">
                                            <?php echo e(__('messages.Website_Design_Development')); ?>

                                        </div>
                                        <div class="testimonialText">
                                        <?php echo e(__('messages.Website_Content_2')); ?>

                                            
                                        </div>
                                        <a href="https://numu.sa
                                        " target="_blank" class="btn btn-primary">
                                            <?php echo e(__('messages.View_Project')); ?>

                                            <img class="btn-arrow"
                                                src="<?php echo e(asset('assets/images/btn-arrow-white.svg')); ?>" alt="arrow" />
                                        </a>
                                    </div>
                                    <div class="tesSlideDesigCol">
                                        <div class="tesDesigCard">
                                            <div class="client-logo"><img src="<?php echo e(asset('assets/images/numu-logo.png')); ?>" alt="client" /></div>
                                            <div class="clientDetail">
                                                <div class="clientName">
                                                    <?php echo e(__('messages.client_name_2')); ?>

                                                </div>
                                                <div class="clientDesig">
                                                <?php echo e(__('messages.Project')); ?>, <?php echo e(__('messages.Numu_Garden')); ?> 
                                                </div>
                                            </div>
                                        </div>
                                        <div class="tesRatingCard">
                                            <div class="ratingStar">
                                                <img src="<?php echo e(asset('assets/images/star-white.svg')); ?>" alt="rating" />
                                            </div>
                                            <div class="ratingDetail">
                                                <div class="ratingDesig">
                                                <?php echo e(__('messages.Rating')); ?>

                                                </div>
                                                <div class="ratingName">
                                                <?php echo e(__('messages.Best')); ?>   
                                                </div>
                                            </div>
                                            <div class="ratingStar ratingStarRes">
                                                <img src="<?php echo e(asset('assets/images/star-white.svg')); ?>" alt="rating" />
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="slider-nav-wrapper">
                            <div class="slider-nav-container">
                                <div class="slider-nav">
                                    <div class="firstNav progAdded">
                                        <svg class="c-progress-ring" width="90" height="90" viewBox="0 0 90 90">
                                            <circle cx="45" cy="45" r="42"></circle>
                                            <circle class="c-progress-line" cx="45" cy="45" r="42"
                                                style="stroke-dasharray: 273.319px, 273.319px; stroke-dashoffset: 0; opacity: 1;"></circle>
                                        </svg>
                                        <div class="client-img"><img src="<?php echo e(asset('assets/images/aab-icon.png')); ?>" alt="client" /></div>
                                    </div>
                                    <div>
                                        <svg class="c-progress-ring" width="90" height="90" viewBox="0 0 90 90">
                                            <circle cx="45" cy="45" r="42"></circle>
                                            <circle class="c-progress-line" cx="45" cy="45" r="42"
                                                style="stroke-dasharray: 273.319px, 273.319px; stroke-dashoffset: 0; opacity: 1;"></circle>
                                        </svg>
                                        <div class="client-img"><img src="<?php echo e(asset('assets/images/numu-icon.png')); ?>" alt="client" /></div>
                                    </div>
                                    <div class="firstNav progAdded">
                                        
                                        <svg class="c-progress-ring" width="90" height="90" viewBox="0 0 90 90">
                                            <circle cx="45" cy="45" r="42"></circle>
                                            <circle class="c-progress-line" cx="45" cy="45" r="42"
                                                style="stroke-dasharray: 273.319px, 273.319px; stroke-dashoffset: 0; opacity: 1;"></circle>
                                        </svg>
                                        <div class="client-img"><img src="<?php echo e(asset('assets/images/aab-icon.png')); ?>" alt="client" /></div>
                                    </div>
                                    <div>
                                        <svg class="c-progress-ring" width="90" height="90" viewBox="0 0 90 90">
                                            <circle cx="45" cy="45" r="42"></circle>
                                            <circle class="c-progress-line" cx="45" cy="45" r="42"
                                                style="stroke-dasharray: 273.319px, 273.319px; stroke-dashoffset: 0; opacity: 1;"></circle>
                                        </svg>
                                        <div class="client-img"><img src="<?php echo e(asset('assets/images/numu-icon.png')); ?>" alt="client" /></div>
                                    </div>
                                </div>
                            </div>
                            
                        </div>
                    </div>
                    
                </div>
                
            </div>

            <div class="row">
                <div class="col-12 why-choose-main-col">
                    <div class="primaryHeading">
                        <?php echo e(__('messages.WhyBoost')); ?>

                    </div>
                    <div class="why-choose-points">
                        <div class="why-choose-col">
                            <div class="why-choose-heading-icon">
                                <div class="why-choose-icon">
                                    <img src="<?php echo e(asset('assets/images/star.svg')); ?>" alt="star">
                                    <span class="why-choose-number">1</span>
                                </div>
                                <span class="why-choose-heading">
                                    <?php echo e(__('messages.whyChooseH1')); ?>

                                </span>
                            </div>
                            <span class="why-choose-text">
                                <?php echo e(__('messages.whyChooseT1')); ?>

                            </span>
                        </div>
                        <div class="why-choose-col">
                            <div class="why-choose-heading-icon">
                                <div class="why-choose-icon">
                                    <img src="<?php echo e(asset('assets/images/star.svg')); ?>" alt="star">
                                    <span class="why-choose-number">2</span>
                                </div>
                                <span class="why-choose-heading">
                                    <?php echo e(__('messages.whyChooseH2')); ?>

                                </span>
                            </div>
                            <span class="why-choose-text">
                                <?php echo e(__('messages.whyChooseT2')); ?>

                            </span>
                        </div>
                        <div class="why-choose-col">
                            <div class="why-choose-heading-icon">
                                <div class="why-choose-icon">
                                    <img src="<?php echo e(asset('assets/images/star.svg')); ?>" alt="star">
                                    <span class="why-choose-number">3</span>
                                </div>
                                <span class="why-choose-heading">
                                    <?php echo e(__('messages.whyChooseH3')); ?>

                                </span>
                            </div>
                            <span class="why-choose-text">
                                <?php echo e(__('messages.whyChooseT3')); ?>

                            </span>
                        </div>
                        <div class="why-choose-col">
                            <div class="why-choose-heading-icon">
                                <div class="why-choose-icon">
                                    <img src="<?php echo e(asset('assets/images/star.svg')); ?>" alt="star">
                                    <span class="why-choose-number">4</span>
                                </div>
                                <span class="why-choose-heading">
                                    <?php echo e(__('messages.whyChooseH4')); ?>

                                </span>
                            </div>
                            <span class="why-choose-text">
                                <?php echo e(__('messages.whyChooseT4')); ?>

                            </span>
                        </div>
                        <div class="why-choose-col">
                            <div class="why-choose-heading-icon">
                                <div class="why-choose-icon">
                                    <img src="<?php echo e(asset('assets/images/star.svg')); ?>" alt="star">
                                    <span class="why-choose-number">5</span>
                                </div>
                                <span class="why-choose-heading">
                                    <?php echo e(__('messages.whyChooseH5')); ?>

                                </span>
                            </div>
                            <span class="why-choose-text">
                                <?php echo e(__('messages.whyChooseT5')); ?>

                            </span>
                        </div>
                        <div class="why-choose-col">
                            <div class="why-choose-heading-icon">
                                <div class="why-choose-icon">
                                    <img src="<?php echo e(asset('assets/images/star.svg')); ?>" alt="star">
                                    <span class="why-choose-number">6</span>
                                </div>
                                <span class="why-choose-heading">
                                    <?php echo e(__('messages.whyChooseH6')); ?>

                                </span>
                            </div>
                            <span class="why-choose-text">
                                <?php echo e(__('messages.whyChooseT6')); ?>

                            </span>
                        </div>
                        <div class="why-choose-col">
                            <div class="why-choose-heading-icon">
                                <div class="why-choose-icon">
                                    <img src="<?php echo e(asset('assets/images/star.svg')); ?>" alt="star">
                                    <span class="why-choose-number">7</span>
                                </div>
                                <span class="why-choose-heading">
                                    <?php echo e(__('messages.whyChooseH7')); ?>

                                </span>
                            </div>
                            <span class="why-choose-text">
                                <?php echo e(__('messages.whyChooseT7')); ?>

                            </span>
                        </div>
                        <div class="why-choose-col">
                            <div class="why-choose-heading-icon">
                                <div class="why-choose-icon">
                                    <img src="<?php echo e(asset('assets/images/star.svg')); ?>" alt="star">
                                    <span class="why-choose-number">8</span>
                                </div>
                                <span class="why-choose-heading">
                                    <?php echo e(__('messages.whyChooseH8')); ?>

                                </span>
                            </div>
                            <span class="why-choose-text">
                                <?php echo e(__('messages.whyChooseT8')); ?>

                            </span>
                        </div>
                        <div class="why-choose-col">
                            <div class="why-choose-heading-icon">
                                <div class="why-choose-icon">
                                    <img src="<?php echo e(asset('assets/images/star.svg')); ?>" alt="star">
                                    <span class="why-choose-number">9</span>
                                </div>
                                <span class="why-choose-heading">
                                    <?php echo e(__('messages.whyChooseH9')); ?>

                                </span>
                            </div>
                            <span class="why-choose-text">
                                <?php echo e(__('messages.whyChooseT9')); ?>

                            </span>
                        </div>
                        <div class="why-choose-col">
                            <div class="why-choose-heading-icon">
                                <div class="why-choose-icon">
                                    <img src="<?php echo e(asset('assets/images/star.svg')); ?>" alt="star">
                                    <span class="why-choose-number">10</span>
                                </div>
                                <span class="why-choose-heading">
                                    <?php echo e(__('messages.whyChooseH10')); ?>

                                </span>
                            </div>
                            <span class="why-choose-text">
                                <?php echo e(__('messages.whyChooseT10')); ?>

                            </span>
                        </div>
                        <div class="why-choose-col">
                            <div class="why-choose-heading-icon">
                                <div class="why-choose-icon">
                                    <img src="<?php echo e(asset('assets/images/star.svg')); ?>" alt="star">
                                    <span class="why-choose-number">11</span>
                                </div>
                                <span class="why-choose-heading">
                                    <?php echo e(__('messages.whyChooseH11')); ?>

                                </span>
                            </div>
                            <span class="why-choose-text">
                                <?php echo e(__('messages.whyChooseT11')); ?>

                            </span>
                        </div>
                        <div class="why-choose-col">
                            <div class="why-choose-heading-icon">
                                <div class="why-choose-icon">
                                    <img src="<?php echo e(asset('assets/images/star.svg')); ?>" alt="star">
                                    <span class="why-choose-number">12</span>
                                </div>
                                <span class="why-choose-heading">
                                    <?php echo e(__('messages.whyChooseH12')); ?>

                                </span>
                            </div>
                            <span class="why-choose-text">
                                <?php echo e(__('messages.whyChooseT12')); ?>

                            </span>
                        </div>


                    </div>
                </div>
            </div>
        </div>

    </section>

    <section class="container-fluid section-git-wrapper" id='testimonial'>
        <div class="container container-git-wrapper">
            <div class="git-img">
                <img class="" src="<?php echo e(asset('assets/images/git.png')); ?>" alt="getInTouch">
            </div>
            <div class="git-th-wrapper">
                <div class="git-text">
                    <?php echo e(__('messages.timeToLevelUp')); ?>

                </div>
                <div class="git-heading __bold">
                    <span><?php echo e(__('messages.GetInTouch')); ?></span>
                </div>
            </div>
            <div class="git-btn">
                <a href="https://wa.me/+966581506065" target="_blank" class="btn btn-yellow">
                    <?php echo e(__('messages.OrderNow3')); ?> <img class="btn-arrow"
                        src="<?php echo e(asset('assets/images/btn-arrow-blue.svg')); ?>" alt="arrow" />
                </a>
            </div>
        </div>
    </section>


    <section class="container-fluid common-section portfolio-wrapper" id="Portfolio">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="primaryHeading justify-content-center text-center">
                        <?php echo e(__('messages.portfolioHeading')); ?>

                    </div>
                    <div class="primaryText mb-3 justify-content-center text-center">
                        <?php echo e(__('messages.portfolioText')); ?>

                    </div>
                </div>
            </div>
            <div class="row row-portfolio">
                <div class="col-12 col-md-6 col-lg-4 col-portfolio p-0">
                    <a href="https://maq.com.sa" target="_blank"><img
                            src="<?php echo e(asset('assets/images/portfolio-1.jpg')); ?>" alt="maq"></a>
                </div>
                <div class="col-12 col-md-6 col-lg-4 col-portfolio p-0">
                    <a href="https://suhuula.com" target="_blank"><img
                            src="<?php echo e(asset('assets/images/portfolio-2.jpg')); ?>" alt="suhuula"></a>
                </div>
                
                
                <div class="col-12 col-md-6 col-lg-4 col-portfolio p-0">
                    <a href="https://topmodern.sa/" target="_blank"><img
                            src="<?php echo e(asset('assets/images/portfolio-5.jpg')); ?>" alt="aab"></a>
                </div>
                <div class="col-12 col-md-6 col-lg-4 col-portfolio p-0">
                    <a href="https://daimoun.com" target="_blank"><img
                            src="<?php echo e(asset('assets/images/portfolio-6.jpg')); ?>" alt="daimoun"></a>
                </div>
                <div class="col-12 col-md-6 col-lg-4 col-portfolio p-0">
                    <a href="https://beehive.delivery" target="_blank"><img
                            src="<?php echo e(asset('assets/images/portfolio-7.jpg')); ?>" alt="beehive"></a>
                </div>
                <div class="col-12 col-md-6 col-lg-4 col-portfolio p-0">
                    <a href="https://shipzy.co" target="_blank"><img
                            src="<?php echo e(asset('assets/images/portfolio-8.jpg')); ?>" alt="shipzy"></a>
                </div>
                <div class="col-12 col-md-6 col-lg-4 col-portfolio p-0">
                    <a href="https://beepallabeep.com" target="_blank"><img
                            src="<?php echo e(asset('assets/images/portfolio-9.jpg')); ?>" alt="beepallabeep"></a>
                </div>
                <!-- <div class="col-12 col-md-6 col-lg-4 col-portfolio p-0">
                    <a href="https://numu.sa" target="_blank"><img
                            src="<?php echo e(asset('assets/images/portfolio-10.jpg')); ?>" alt="numugardens"></a>
                </div> -->
                <div class="col-12 col-md-6 col-lg-4 col-portfolio p-0">
                    <a href="https://numu.sa" target="_blank"><img
                            src="<?php echo e(asset('assets/images/numg.png')); ?>" alt="numug"></a>
                </div>
                <div class="col-12 col-md-6 col-lg-4 col-portfolio p-0">
                    <a href="https://albarraktrd.sa" target="_blank"><img
                            src="<?php echo e(asset('assets/images/albarrak.png')); ?>" alt="albarrak"></a>
                </div>
                <div class="col-12 col-md-6 col-lg-4 col-portfolio p-0">
                    <a href="https://sahabalalam.sa" target="_blank"><img
                            src="<?php echo e(asset('assets/images/sahab.png')); ?>" alt="sahab"></a>
                </div>
                <!-- <div class="col-12 col-md-6 col-lg-4 col-portfolio p-0">
                    <a href="https://albarraktrd.sa" target="_blank"><img
                            src="<?php echo e(asset('assets/images/quantum.png')); ?>" alt="quantum"></a>
                </div> -->
                <div class="col-12 col-md-6 col-lg-4 col-portfolio p-0">
                    <a href="https://ahouse.sa" target="_blank"><img
                            src="<?php echo e(asset('assets/images/advanced.png')); ?>" alt="advanced"></a>
                </div>
                <div class="col-12 col-md-6 col-lg-4 col-portfolio p-0">
                    <a href="https://websites.fowl.sa/" target="_blank"><img
                            src="<?php echo e(asset('assets/images/portfolio-4.jpg')); ?>" alt="mohd"></a>
                </div>
            </div>
        </div>
    </section>

    <section class="container-fluid common-section contact-wrapper" id="Contact">
        <div class="container">
            <div class="row contact-row">

                <div class="col-md-12 col-lg-6 contact-col-first">

                    <div class="row">
                        <div class="primaryHeading">
                            <?php echo e(__('messages.contactHeading')); ?>

                        </div>
                        <div class="primaryText">
                            <?php echo e(__('messages.contactText')); ?>

                        </div>
                        <div class="col-md-12 contactDetailRow">
                            <div class="contactDetailIcon contactDetailIconPhone">
                                <img src="<?php echo e(asset('assets/images/call2.svg')); ?>" alt="call" />
                            </div>
                            <div class="contactDetailText contactDetailTextPhone">
                                <a href="tel:+966581506065" target="_blank">
                                    +966 58 150 6065
                                </a>
                            </div>
                        </div>
                        <div class="col-md-12 contactDetailRow">
                            <div class="contactDetailIcon">
                                <img src="<?php echo e(asset('assets/images/whatsapp2.svg')); ?>" alt="whatsapp" />
                            </div>
                            <div class="contactDetailText contactDetailTextPhone">
                                <a href="https://wa.me/+966581506065" target="_blank">
                                    +966 58 150 6065
                                </a>
                            </div>
                        </div>
                        <div class="col-md-12 contactDetailRow">
                            <div class="contactDetailIcon">
                                <img src="<?php echo e(asset('assets/images/email.svg')); ?>" alt="email" />
                            </div>
                            <div class="contactDetailText contactDetailTextEmail">
                                <a href="mailto:info@fowl.sa" target="_blank">
                                    info@fowl.sa
                                </a>
                            </div>
                        </div>

                    </div>

                </div>
                <div class="col-md-12 col-lg-6 contact-col-second">
                    <form id="contact-us-form" action="javascript:void(0)" method="POST">
                        <?php echo csrf_field(); ?>
                        <div class="row">

                            <div class="col-12 form-group">
                                <label><?php echo e(__('messages.name')); ?></label>
                                <div class="formInputRow">
                                    <div class="contactFormIcon">
                                        <img src="<?php echo e(asset('assets/images/name.svg')); ?>" alt="name">
                                    </div>
                                    <input type="text" name="contact_name" class="form-control"
                                        placeholder="<?php echo e(__('messages.namePlaceholder')); ?>">
                                </div>
                            </div>
                            <div class="col-12 form-group">
                                <label><?php echo e(__('messages.Country')); ?></label>
                                <div class="formInputRow">

                                    <div class="niceCountryInputSelector" data-selectedcountry="SA"
                                        data-showspecial="false" data-showflags="true" data-i18nall="All selected"
                                        data-i18nnofilter="No selection" data-i18nfilter="Filter"
                                        data-onchangecallback="onChangeCallback">
                                    </div>
                                    
                                </div>
                            </div>

                            <div class="col-12 form-group">
                                <label><?php echo e(__('messages.Phone')); ?></label>
                                <div class="formInputRow">
                                    <div class="contactFormIcon">
                                        <img src="<?php echo e(asset('assets/images/call-input.svg')); ?>" alt="call">
                                    </div>
                                    <input type="tel" name="contact_phone"
                                        class="form-control contactFormInputPhone"
                                        placeholder="<?php echo e(__('messages.phonePlaceholder')); ?>">
                                </div>
                            </div>
                            <div class="col-12 form-group">
                                <label><?php echo e(__('messages.ProjectType')); ?></label>
                                <div class="formInputRow">
                                    <div class="contactFormIcon">
                                        <img src="<?php echo e(asset('assets/images/project-type.svg')); ?>" alt="projectType">
                                    </div>
                                    <input type="text" name="project_type" class="form-control"
                                        placeholder="<?php echo e(__('messages.ProjectTypePlaceholder')); ?>">
                                </div>
                            </div>

                        </div>
                        <button type="submit" id="submit" class="btn btn-primary">
                            <?php echo e(__('messages.Send')); ?> <img src="<?php echo e(asset('assets/images/btn-arrow-white.svg')); ?>"
                                alt="arrow" />
                        </button>
                    </form>
                </div>
            </div>
            <img class="contact-img" src="<?php echo e(asset('assets/images/contact.png')); ?>" alt="logo" />
        </div>
    </section>

    <footer class="container-fluid bg-blue">
        <div class="container">
            <div class="row footer-content">
                <div class="col-12 col-footer-content">
                    <div class="logo-numbers">
                        <div class="footer-logo">
                            <img src="<?php echo e(asset('assets/images/logo-footer.svg')); ?>" alt="logo" />
                        </div>
                        <div class="footer-numbers">
                            <div class="footerDetailRow">
                                <div class="footerDetailIcon">
                                    <img src="<?php echo e(asset('assets/images/call2.svg')); ?>" alt="call" />
                                </div>
                                <div class="footerDetailText __medium">
                                    <a href="tel:+966581506065" target="_blank">
                                        +966 58 150 6065
                                    </a>
                                </div>
                            </div>
                            <div class="footerDetailRow">
                                <div class="footerDetailIcon">
                                    <img src="<?php echo e(asset('assets/images/whatsapp-3.svg')); ?>" alt="whatsapp" />
                                </div>
                                <div class="footerDetailText __medium">
                                    <a href="https://wa.me/+966581506065" target="_blank">
                                        +966 58 150 6065
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="copyRight">
                        <span class="__regular">&copy; 2024
                            <a class="__semiBold" href="https://websites.fowl.sa"  target="_blank"><?php echo e(__('messages.Fowl')); ?></a>.
                            <?php echo e(__('messages.AllRights')); ?>

                        </span>
                        <!-- <br> -->
                        <span class="__regular">
                            <?php echo e(__('messages.Developed_by')); ?>

                            <a class="__semiBold" href="https://websites.fowl.sa"  target="_blank"><?php echo e(__('messages.Fowl')); ?></a>.
                        </span>
                    </div>
                    <div class="work-lang-btns work-lang-btns-footer">
                        <a href="https://wa.me/+966581506065" target="_blank"
                            class="btn btn-header text-regular whatsapp-us __semiBold">
                            <div class="call-box"><img src="<?php echo e(asset('assets/images/whatsapp.svg')); ?>"
                                    alt="whatsapp"></div> <?php echo e(__('messages.Whatsapp')); ?>

                        </a>
                        <a href="https://wa.me/+966581506065?text=مرحبا فاول أريد الحصول على إستشارة تساعدني على إنشاء موقع إلكتروني لمشروعي" 
                            target="_blank" class="btn btn-header text-regular free-consultation __semiBold">
                            <?php echo e(__('messages.FreeConsultation')); ?>

                        </a>
                    </div>
                </div>
                <div class="col-12">
                    <div class="copyRight copyRight-2">
                        <span class="__regular">&copy; 2023
                            <a class="__semiBold" href="https://websites.fowl.sa"  target="_blank"><?php echo e(__('messages.Fowl')); ?></a>.
                            <?php echo e(__('messages.AllRights')); ?>

                        </span>
                        <br>
                        <span class="__regular">
                            <?php echo e(__('messages.Developed_by')); ?>

                            <a class="__semiBold" href="https://websites.fowl.sa"  target="_blank"><?php echo e(__('messages.Fowl')); ?></a>.
                        </span>
                    </div>
                </div>
            </div>
        </div>
    </footer>
    <a href="https://wa.me/+966581506065" class="whatsappFixed" target="_blank">
        <img class="" src="<?php echo e(asset('assets/images/whatsapp.png')); ?>">
    </a>
    <div class="select-lang">
    <?php if(app()->getLocale() === 'en'): ?>
    <a href="<?php echo e(route('setLocale', 'ar')); ?>" class="btn btn-default-lang">
        <img class="flag-icon-squared" src="<?php echo e(asset('assets/images/arabic.png')); ?>"
            alt="">
        </a>                                
    <?php else: ?>
        <a href="<?php echo e(route('setLocale', 'en')); ?> " class="btn btn-default-lang">
             <img class="flag-icon-squared" src="<?php echo e(asset('assets/images/english.png')); ?>"
                alt="">
             </a>
    <?php endif; ?>                 
    </div>

    <div class="modal fade" id="free-consultation-modal" tabindex="-1" aria-labelledby="exampleModalLabel"
        aria-modal="true" role="dialog">
        <form class="needs-validation" method="POST" id="consultation-form" action="javascript:void(0)">
            <?php echo csrf_field(); ?>
            <div class="modal-dialog modal-lg modal-dialog-centered modal-dialog-wwu">
                <div class="modal-content">
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                    <div class="modal-body modal-body-wwu">
                        <div class="row features-row order-swipe-1">
                            <div class="col-md-12">

                                <div class="row">
                                    <div class="heading-primary heading-primary-modal __semiBold"><?php echo e(__('messages.GetFreeConsultation')); ?></div>
									<div class="col-md-12">

											<div class="row">
					
												<div class="col-12 form-group">
													<label><?php echo e(__('messages.name')); ?></label>
													<div class="formInputRow">
														<div class="contactFormIcon">
															<img src="<?php echo e(asset('assets/images/name.svg')); ?>" alt="name">
														</div>
														<input type="text" name="consultation_contact_name" class="form-control"
															placeholder="<?php echo e(__('messages.namePlaceholder')); ?>">
													</div>
												</div>
												
												<div class="col-12 form-group">
													<label><?php echo e(__('messages.Phone')); ?></label>
													<div class="formInputRow">
														<div class="contactFormIcon">
															<img src="<?php echo e(asset('assets/images/call-input.svg')); ?>" alt="call">
														</div>
														<input type="tel" name="consultation_contact_phone" 
															class="form-control contactFormInputPhone"
															placeholder="<?php echo e(__('messages.phonePlaceholder')); ?>">
													</div>
												</div>
												<div class="col-12 form-group">
													<label><?php echo e(__('messages.ProjectType')); ?></label>
													<div class="formInputRow">
														<div class="contactFormIcon">
															<img src="<?php echo e(asset('assets/images/project-type.svg')); ?>" alt="projectType">
														</div>
														<input type="text" name="consultation_project_type"  class="form-control"
															placeholder="<?php echo e(__('messages.ProjectTypePlaceholder')); ?>">
													</div>
												</div>
					
											</div>
											<button type="submit" id="submit-cosultation" class="btn btn-primary btn-mod-sub">
												<?php echo e(__('messages.Send')); ?> <img src="<?php echo e(asset('assets/images/btn-arrow-white.svg')); ?>"
													alt="arrow" />
											</button>
										
									</div>
                                                
                                            
                                </div>
                            </div>
                        </div>
                    </div>
                    
                </div>
            </div>
        </form>
    </div>

    <script src="<?php echo e(asset('assets/js/jquery-3.6.1.min.js')); ?>" type="text/javascript"></script>
    <script src="<?php echo e(asset('assets/js/bootstrap.min.js')); ?>" type="text/javascript"></script>
    <script src="<?php echo e(asset('assets/js/scrollspy.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/mains.js')); ?>" type="text/javascript"></script>
    <script src="<?php echo e(asset('assets/js/custom.js')); ?>" type="text/javascript"></script>
    
    <script src="<?php echo e(asset('assets/js/sweetalert2.all.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/niceCountryInput.js')); ?>"></script>
    <script type="text/javascript" src="<?php echo e(asset('assets/js/slick.min.js')); ?>"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery-validate/1.19.0/jquery.validate.min.js"></script>
    

    

    
   
    <script>
        function onChangeCallback(ctr) {
            console.log("The country was changed: " + ctr);
            //$("#selectionSpan").text(ctr);
        }

        $(document).ready(function() {
            $(".niceCountryInputSelector").each(function(i, e) {
                new NiceCountryInput(e).init();
            });
        });
    </script>
    <script>
        $(document).ready(function() {
            // alert('hi');
            $("#contact-us-form").validate({
                rules: {
                    contact_name: {
                        required: true,
                    },
                    contact_phone: {
                        required: true,
                        number: true,
                    },
                    country_name: {
                        required: true,
                    },
                    project_type: {
                        required: true,
                    },

                },
                messages: {
                    contact_name: {
                        required: "<?php echo e(__('messages.contactNameValidate')); ?>",
                    },
                    contact_phone: {
                        required: "<?php echo e(__('messages.contactPhoneValidate')); ?>",
                    },
                    country_name: {
                        required: "<?php echo e(__('messages.countryValidate')); ?>",
                    },
                    project_type: {
                        required: "<?php echo e(__('messages.projectTypeValidate')); ?><?php echo e(__('')); ?>",
                    },
                },
                submitHandler: function(form) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('input[name="_token"]').val()
                        }
                    });
                    $("#submit").attr("disabled", true);
                    $.ajax({
                        url: "<?php echo e(route('send_email')); ?>",
                        method: "POST",
                        data: $('#contact-us-form').serialize(),
                        dataType: 'json', // type of data expecting back from server
                        success: function(data) {
                            const {
                                status,
                                message
                            } = data;
                            $("#submit").attr("disabled", false);
                            if (status == '<?php echo e(__('messages.success')); ?>') {
                                Swal.fire({
                                    icon: 'success',
                                    title: `${status}`,
                                    text: `${"<?php echo e(__('messages.your_message_sent_successfully')); ?>"}`,
                                }).then(function() {
                                    document.getElementById("contact-us-form")
                                        .reset();
                                });
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: `${status}`,
                                    text: `${message}`,
                                })
                            }
                        },
                        error: function(data) {
                            console.log(data);
                        }
                    });
                }

            });
        });
    </script>
    <script>
        //$(document).ready(function() {
            /*
        setTimeout(function() {
            $('#free-consultation-modal').modal('show');
        }, 5000); // 5000 milliseconds = 5 seconds
        */
       // });
    </script>
    <script>
         $(document).ready(function() {
            // alert('hi');
            $("#consultation-form").validate({
                
                rules: {
                    consultation_contact_name: {
                        required: true,
                    },
                    consultation_contact_phone: {
                        required: true,
                        number: true,
                    },
                  
                    consultation_project_type: {
                        required: true,
                    },

                },
                messages: {
                    consultation_contact_name: {
                        required: "<?php echo e(__('messages.contactNameValidate')); ?>",
                    },
                    consultation_contact_phone: {
                        required: "<?php echo e(__('messages.contactPhoneValidate')); ?>",
                    },
                   
                    consultation_project_type: {
                        required: "<?php echo e(__('messages.projectTypeValidate')); ?>",
                    },
                },
                
                submitHandler: function(form) {
                    $.ajaxSetup({
                        headers: {
                            'X-CSRF-TOKEN': $('input[name="_token"]').val()
                        }
                    });
                    $("#submit-cosultation").attr("disabled", true);
                    $.ajax({
                        url: "<?php echo e(route('send_consultation_email')); ?>",
                        method: "POST",
                        data: $('#consultation-form').serialize(),
                        dataType: 'json', // type of data expecting back from server
                        success: function(data) {
                            const {
                                status,
                                message
                            } = data;
                            $("#submit-cosultation").attr("disabled", false);
                            if (status == '<?php echo e(__('messages.success')); ?>') {
                                Swal.fire({
                                    icon: 'success',
                                    title: `${status}`,
                                    text: `${"<?php echo e(__('messages.your_message_sent_successfully')); ?>"}`,
                                }).then(function() {
                                    document.getElementById("consultation-form")
                                        .reset();
                                });
                            } else {
                                Swal.fire({
                                    icon: 'error',
                                    title: `${status}`,
                                    text: `${message}`,
                                })
                            }
                        },
                        error: function(data) {
                            console.log(data);
                        }
                    });
                }

            });
        });
    </script>

    <script>
        //$(document).ready(function() {
            $('.slider-for').slick({
                slidesToShow: 1,
                slidesToScroll: 1,
                arrows: false,
                fade: true,
                asNavFor: '.slider-nav'
            });
            $('.slider-nav').slick({

                slidesToShow: 3,
                slidesToScroll: 1,
                asNavFor: '.slider-for',
                autoplay: true,
                arrows: true, 
                autoplaySpeed: 3000,
                dots: false,
                centerMode: true,
                pauseOnFocus: false,
                pauseOnHover: false,
                pauseOnDotsHover: false,
                focusOnSelect: true,
                centerPadding: '0px'

            }).on('afterChange', function (event, slick, currentSlide, nextSlide) {
                // Remove the class from all slides
                //$('.slider-nav .slick-slide').removeClass('custom-class');

                // Add the class to the currently active slide
                $('.slider-nav .slick-current').addClass('progAdded');
            });
        //});
    </script>

</body>

</html>
<?php /**PATH D:\arham_dev\Fowl-Websites-Leads-Platform\resources\views/web/index.blade.php ENDPATH**/ ?>